unit AprroxCentr01;

interface
uses Windows, Messages, SysUtils, Variants, Classes, StdCtrls,
     Dialogs, Graphics, Grids, ComCtrls, Math, Controls, Forms,
     MainData, GraphXYv50, Report01,
     LeastSquares01, Fourier01, ShowGraph01;
// ==========================================================
//    PROJECT
// ==========================================================
// ==========================================================
//    PROJECT
// ==========================================================
// ==========================================================
//    PROJECT
// ==========================================================
// ==========================================================
//      PROJECT
// ==========================================================
//  UNIT AprroxCentr01
procedure InitAprroxCentr01(RqForm            : TForm;
                            RqCBoxAproxSelect : TComboBox;
                            RqEdAproxMaxInd   : TEdit;
                            RqSTxtTermSeries  : TStaticText;
                            RqSG01AproxKoeff  : TStringGrid;
                            RqSTxtRelativErr  : TStaticText;
                            RqLViewBasis      : TListView);
//      CBoxAproxSelect
procedure RunSelectAprox();
//     
//   
procedure ShowDetalAproxFunc (RqDetal, RqMethod, RqSeries : word);

implementation

// ==========================================================
//    UNIT
// ==========================================================
//     
var
    CtrlForm            : TForm;
    CtrlCBoxAproxSelect : TComboBox;
    CtrlEdAproxMaxInd   : TEdit;
    CtrlSTxtTermSeries  : TStaticText;
    CtrlSG01AproxKoeff  : TStringGrid;
    CtrlSTxtRelativErr  : TStaticText;
    CtrlLViewBasis      : TListView;

var TermSeriesTxt       : string;

// ==========================================================
//      /  UNIT
// ==========================================================
procedure InitSG01AproxKoeff();
begin
  with CtrlSG01AproxKoeff do
   begin
     ColCount  := 5;
     RowCount  := 2;
     FixedCols := 1;
     FixedRows := 1;
     Cells[0,0]:= ' n';
     Cells[1,0]:= ' An';
     Cells[2,0]:= ' Bn';
     Cells[3,0]:= ' Cn';
     Cells[4,0]:= ' Pn';
   end;
end;
// -----------------------------------------------------
//
//  UNIT AprroxCentr01
procedure InitAprroxCentr01(RqForm            : TForm;
                            RqCBoxAproxSelect : TComboBox;
                            RqEdAproxMaxInd   : TEdit;
                            RqSTxtTermSeries  : TStaticText;
                            RqSG01AproxKoeff  : TStringGrid;
                            RqSTxtRelativErr  : TStaticText;
                            RqLViewBasis      : TListView);
begin
   //       
   CtrlForm            := RqForm;
   CtrlCBoxAproxSelect := RqCBoxAproxSelect;
   CtrlEdAproxMaxInd   := RqEdAproxMaxInd;
   CtrlSG01AproxKoeff  := RqSG01AproxKoeff;
   CtrlSTxtTermSeries  := RqSTxtTermSeries;
   CtrlSTxtRelativErr  := RqSTxtRelativErr;
   CtrlLViewBasis      := RqLViewBasis ;
   //   
   InitSG01AproxKoeff();
end; // of procedure

// ==========================================================
//      
// ==========================================================
//-----------------------------------------------------------
// 26.09.2008
//       
function TextToInt (Text : string; var Digit : integer): boolean;
begin
  TextToInt := False;
  try
    Digit := StrToInt(Text);
    TextToInt := True;
  except
  end;
end; {of function}

// ==========================================================
//      
// ==========================================================
//-----------------------------------------------------------
//
//       LViewBasis.
procedure SetKoeffToLViewBasis(RqMethod : word);
var Ind    : integer;
    LVItem : TListItem;
begin
  with CtrlLViewBasis do
  begin
    //  ViewList
    Items.Clear;
    //  ViewList   BasisSelectList
    case RqMethod of
      cmLSquares : begin  //    
         if (Length(LSquaresKoeff) > 0)
         then begin
           SetLength(BasisSelectList, Length(LSquaresKoeff));
           for Ind := Low(LSquaresKoeff) to  High(LSquaresKoeff) do
           begin
             LVItem := Items.Add;
             LVItem.ImageIndex := -1;
             LVItem.StateIndex := -1;
             LVItem.Caption := IntToStr(Ind);
             LVItem.SubItems.Add(FloatToStrF(LSquaresKoeff[Ind],ffExponent,6,9));
             LVItem.Checked := False;
             BasisSelectList[Ind] := False;
           end;
         end;
      end;  // of cmLSquares
      cmFourier  : begin //    
         if (Length(FourierKoeff) > 0)
         then begin
           SetLength(BasisSelectList, Length(FourierKoeff));
           for Ind := Low(FourierKoeff) to High(FourierKoeff) do
           begin
             LVItem := Items.Add;
             LVItem.ImageIndex := -1;
             LVItem.StateIndex := -1;
             LVItem.Caption := IntToStr(Ind);
             LVItem.SubItems.Add(FloatToStrF(FourierKoeff[Ind].AKoeff,ffExponent,6,9));
             LVItem.SubItems.Add(FloatToStrF(FourierKoeff[Ind].BKoeff,ffExponent,6,9));
             LVItem.Checked := False;
             BasisSelectList[Ind] := False;
           end;
         end;
      end; // of cmFourier
    end; // of case RqMethod
  end; // of with CtrlLViewBasis
end; // of procedure

// -----------------------------------------------------
//
//       SG01AproxKoeff
procedure SetKoeffToSG01AproxKoeff(RqMethod : word);
var Ind, WCol, WRow : word;
begin
   case RqMethod of
   cmLSquares : begin  //    
         CtrlSG01AproxKoeff.RowCount := Length(LSquaresKoeff) + 1;
         for Ind := Low(LSquaresKoeff) to High(LSquaresKoeff)
         do begin
           WRow := Ind + 1;
           for WCol:= 0 to (CtrlSG01AproxKoeff.ColCount-1) do
           begin
             with CtrlSG01AproxKoeff do
             begin
               case WCol of
               0:   Cells[WCol,WRow]:= IntToStr(Ind);
               1:   Cells[WCol,WRow]:= FloatToStr(LSquaresKoeff[Ind]);
               else Cells[WCol,WRow]:= ' ';
               end;
             end;
           end; // for WCol
         end; // for Ind
       end;
   cmFourier : begin //    
          CtrlSG01AproxKoeff.RowCount := Length(FourierKoeff) + 1;
          for Ind := Low(FourierKoeff) to High(FourierKoeff)
          do begin
           WRow := Ind + 1;
           for WCol:= 0 to (CtrlSG01AproxKoeff.ColCount-1) do
           begin
             with CtrlSG01AproxKoeff do
             begin
               case WCol of
               0:   Cells[WCol,WRow]:= IntToStr(Ind);
               1:   Cells[WCol,WRow]:= FloatToStr(FourierKoeff[Ind].AKoeff);
               2:   Cells[WCol,WRow]:= FloatToStr(FourierKoeff[Ind].BKoeff);
               3:   Cells[WCol,WRow]:= FloatToStr(FourierKoeff[Ind].CKoeff);
               4:   Cells[WCol,WRow]:= FloatToStr(FourierKoeff[Ind].PKoeff);
               else Cells[WCol,WRow]:= ' ';
               end;
             end;
           end; // for WCol
         end; // for Ind
       end; // of 2
   end; // of case RqMethod
end;  // of procedure

// ==========================================================
//     
// ==========================================================
// -----------------------------------------------------
//
//    (Series)      
function  GetSeriesValue(RqMethod, RqSeries : word; RqX : extended):extended;
begin
 GetSeriesValue := 0;
 case RqMethod of
   cmLSquares : begin  //    
       GetSeriesValue := CalcPolinom (RqSeries, LSquaresKoeff, RqX );
   end;
   cmFourier : begin   //   
      case RqSeries of
        //       ,
        cfFourierAB : begin
          GetSeriesValue := CalcFourierFuncAB(RqX);
        end;
      end; // of case RqSeries
   end;
 end; // of case RqMethod
end; // of function

// -----------------------------------------------------
//
//     , 
// ,  
procedure ShowDetalAproxFunc
    (RqDetal, RqMethod, RqSeries : word);
var DetalAproxFuncTAB : TGraphArr;
    Ind               : word;
    Period, WX, WY     : extended;
begin
 if (LastExecuteMethod > 0) and (LastExecuteSeries > 0)
 then begin
      Period := TableFuncionArray[High(TableFuncionArray)].X
              - TableFuncionArray[Low(TableFuncionArray)].X;
      //   
      SetLength(DetalAproxFuncTAB, RqDetal);
      for Ind := Low(DetalAproxFuncTAB) to High(DetalAproxFuncTAB) do
      begin
         //    
         WX := TableFuncionArray[Low(TableFuncionArray)].X
             + (Period / RqDetal) * Ind ;
         WY := GetSeriesValue(RqMethod, RqSeries, WX);
         DetalAproxFuncTAB[Ind].X:= WX;
         DetalAproxFuncTAB[Ind].Y:= WY;
      end;
      //    .
      LinePaintTablePointXY(DetalAproxFuncTAB);
 end;
end; // of procedure

// -----------------------------------------------------
//
//     
//    
function DetalIntegrOrAreaAproxFunc
        (RqArea : boolean; RqDetal, RqMethod, RqSeries : word) : extended;
var
    Ind             : word;
    XB, XE, WX      : extended;
    WYp, WYc, Sum   : extended;
    Period, StepX   : extended;
begin
 DetalIntegrOrAreaAproxFunc := 0;
 if (LastExecuteMethod > 0) and (LastExecuteSeries > 0)
 then begin
    XB := TableFuncionArray[High(TableFuncionArray)].X;
    XE := TableFuncionArray[Low(TableFuncionArray)].X;
    Period := XE - XB;
    StepX := Period / RqDetal;
    Sum := 0;
    WYp := 0;
    for Ind := 0 to RqDetal do
    begin
       //   
       WX := XB + StepX * Ind ;
       //   
       WYc := GetSeriesValue(RqMethod, RqSeries, WX);
       if Ind > 0
       then begin
         //     
         if RqArea
         then begin
           //      F(X)
           Sum := Sum + Abs((WYp + WYc)* StepX / 2);
         end
         else begin
           //    F(X)
           Sum := Sum + (WYp + WYc)* StepX / 2;
         end;
       end
       else begin
          //   WYp   
          WYc := GetSeriesValue(RqMethod, RqSeries, WX);
       end; // of if Ind > 0
       //     
       WYp := WYc;
    end; // of for Ind := 0
    DetalIntegrOrAreaAproxFunc := Sum;
 end;
end; // of function

// ==========================================================
//       
// ==========================================================
// ----------------------------------------------------------
//
//     
procedure AproximationStatisticToReport();
begin
 TextToReport(':');
 TextToReport(' 1.    : ' +
                   FloatToStr(AproxSatistic.MaxAbsError));
 TextToReport(' 2.     : ' +
                   FloatToStr(AproxSatistic.MinAbsError));
 InfoToReport(' 3.1.     .: ' +
                     FloatToStr(AproxSatistic.AbsFuncArea));
 InfoToReport(' 3.2      : ' +
                     FloatToStr(AproxSatistic.AbsAproxArea));
 InfoToReport(' 3.3.     : ' +
                     FloatToStr(AproxSatistic.AbsErrorArea));
 TextToReport(' 4.  ( )   : ' +
                    FloatToStr(AproxSatistic.RelativeError));
 TextToReport(':');
 TextToReport('      .. 3.1  3.2,'
            + '      .');
 TextToReport(':');
 TextToReport(' [ ,     ... ]');
 // ------------------------------
 CtrlSTxtRelativErr.Caption := '  '
                   + FloatToStr(AproxSatistic.RelativeError);
end; // of procedure
// -----------------------------------------------------
//
//     
//    
procedure CalculateAproximationStatistic(RqMethod, RqSeries : word);
const cDetalNum  = 4;        //      
var WInd         : word;     //  
    WX, WY, WYAp : extended;   //     
    WdY          : extended;   //    
    WFSum, WESum : extended;   //      

begin
    if (LastExecuteMethod = RqMethod) and (LastExecuteSeries = RqSeries)
    then begin
      //  
      AproxSatistic.MinAbsError  := 0;
      AproxSatistic.MaxAbsError  := 0;
      WFSum := 0;   WESum := 0;
      AproxSatistic.AbsErrorArea := 0;
      //   
      SetLength(AproximationFuncTAB, Length(TableFuncionArray));
      SetLength(AbsErrorFuncTAB, Length(TableFuncionArray));
      for WInd := Low(TableFuncionArray) to High(TableFuncionArray) do
      begin
         //    
         //     
         WX := TableFuncionArray[WInd].X;
         WY := TableFuncionArray[WInd].Y;
         //   
         WYAp := GetSeriesValue(RqMethod, RqSeries, WX);
         AproximationFuncTAB[WInd].X:= WX;
         AproximationFuncTAB[WInd].Y:= WYAp;
         //    
         WdY := WY -WYAp;
         AbsErrorFuncTAB[WInd].X:= WX;
         AbsErrorFuncTAB[WInd].Y:= WdY;
         //  
         if WdY < AproxSatistic.MinAbsError then AproxSatistic.MinAbsError := WdY;
         if WdY > AproxSatistic.MaxAbsError then AproxSatistic.MaxAbsError := WdY;
         if WInd > Low(TableFuncionArray)
         then begin
            WFSum := WFSum
             + Abs( (WY + TableFuncionArray[WInd-1].Y)
                   *(WX - TableFuncionArray[WInd-1].X)/2
                  );
            WESum := WESum
             + Abs((WdY + AbsErrorFuncTAB[WInd-1].Y)
                   *(WX -AbsErrorFuncTAB[WInd-1].X)/2
                   );
         end;
         with AproxSatistic do
         begin
           //      
           AbsFuncArea  := WFSum;
           //       
           AbsErrorArea := WESum;
           AbsAproxArea :=  DetalIntegrOrAreaAproxFunc
             (True, cDetalNum * Length(TableFuncionArray), RqMethod, RqSeries);
           //      
           if AbsFuncArea <> 0
           then RelativeError := 100 * AbsErrorArea / AbsFuncArea;
         end;
      end;
      //     
      AproximationStatisticToReport();
    end;
end; // of procedure

// ==========================================================
//    
// ==========================================================
// -----------------------------------------------------
//
procedure RunAproxLSquares(RqSeries, RqTopIndAproxKoeff : word);
//       .
//  TAproxCB   UNIT: LeastSquares01
var AproxCB       : TAproxCB;
    Ind           : word;
    Save_Cursor   : TCursor;
begin
  //     
  if (Length(TableFuncionArray)) > 2
  then begin
    //    
    Save_Cursor := Screen.Cursor;
    //    
    Screen.Cursor := crHourGlass;
    // -----------------------------------------
    //    
    AproxCB.ptTabFun := Addr(TableFuncionArray);
    //   
    AproxCB.RqExp := RqTopIndAproxKoeff;
    HeadToReport('.   .  : '
                  + ' F ( X ) = U0 ( X ) + U1 ( X ) + ... + Un ( X )'
                 );
    // =========================================
    //     
    RunApprox01 (RqSeries, AproxCB);
    // =========================================
    if (Length(AproxCB.ApAi) > 0) and (AproxCB.Abend = 0)
    then begin
      //  -  
      LastExecuteMethod := -1;
      LastExecuteSeries := -1;
      TextToReport('   n = ' + IntToStr(AproxCB.ApExp));
      TextToReport('   : ' + TermSeriesTxt);
      TextToReport('    : ');
      CtrlSTxtTermSeries.Caption := TermSeriesTxt;
      //    
      //  .
      SetLength(LSquaresKoeff, Length(AproxCB.ApAi));
      SetLength(SpectrLineTab, Length(AproxCB.ApAi));
      //   
      for Ind := Low(AproxCB.ApAi) to High(AproxCB.ApAi) do
      begin
        LSquaresKoeff[Ind] := AproxCB.ApAi[Ind];
        SpectrLineTab[Ind] := AproxCB.ApAi[Ind];
        //     Report
        TextToReport(' A' + IntToStr(Ind)
                         + ' = ' + FloatToStr(AproxCB.ApAi[Ind]));
      end;
      // --------------------------------------
      //   
      LastExecuteMethod := cmLSquares;
      LastExecuteSeries := RqSeries;
      //     
      CalculateAproximationStatistic(cmLSquares, RqSeries);
      //     SG01AproxKoeff
      SetKoeffToSG01AproxKoeff(cmLSquares);
      //     LViewBasis
      SetKoeffToLViewBasis (cmLSquares);
      //     .
      ShowDetalAproxFunc(cMaxDetalGraph, cmLSquares, RqSeries);
      //      
      ShowSpectr(SpectrLineTab, AproximationColor);
      EndCodeReport('  ');
    end
    else begin
       MajorErrorToReport(AproxCB.ApMsg);
       EndCodeReport('   ');
    end;
    // -----------------------------------------
    //  
    Screen.Cursor := Save_Cursor;
  end;
end;

// -----------------------------------------------------
//
procedure RunAproxFourierAB(RqTopIndAproxKoeff : word);
var MsgStr        : string;
    Ind           : word;
    Save_Cursor   : TCursor;
begin
  if (Length(TableFuncionArray)) > 2
  then begin
    //    
    Save_Cursor := Screen.Cursor;
    //    
    Screen.Cursor := crHourGlass;
    // -----------------------
    //  -  
    LastExecuteMethod := -1;
    LastExecuteSeries := -1;
    HeadToReport('.  .  : '
                  + ' F ( X ) = U0 ( X ) + U1 ( X ) + ... + Un ( X )'
                 );
    // ==================================
    //  
    CalcFourierKoeff (RqTopIndAproxKoeff);
    // ==================================
    if (Length(FourierKoeff) > 0)
    then begin
      TextToReport('    1.    : ' + TermSeriesTxt
                   + '   : Period = ( X  - X  )');
      TextToReport('       -1 :');
      CtrlSTxtTermSeries.Caption := TermSeriesTxt;
      //   ,  
      //  .
      SetLength(SpectrLineTab, Length(FourierKoeff));
      // -----------------------
      //    A    Report
      for Ind := Low(FourierKoeff) to High(FourierKoeff) do
      begin
        MsgStr:= ' A' + IntToStr(Ind)
            + ' = '   + FloatToStrF(FourierKoeff[Ind].AKoeff,ffFixed,14,7)
            + #09' B' + IntToStr(Ind)
            + ' = '   + FloatToStr(FourierKoeff[Ind].BKoeff);
        TextToReport(MsgStr);
      end;
      TextToReport('    2.    : '
                   + 'Un = Cn * SIN( n * ( 2 * Pi / Period )* X  + Pn )'
                   + '   : Period = ( X  - X  )');
      TextToReport('       -2 :');
      //    C  P  Report
      for Ind := Low(FourierKoeff) to High(FourierKoeff) do
      begin
        MsgStr:= ' C' + IntToStr(Ind)
            + ' = '   + FloatToStrF(FourierKoeff[Ind].CKoeff,ffFixed,14,7)
            + #09' P' + IntToStr(Ind)
            + ' = '   + FloatToStr(FourierKoeff[Ind].PKoeff);
        TextToReport(MsgStr);
        //     
        SpectrLineTab[Ind] := FourierKoeff[Ind].CKoeff;
      end;
      // -----------------------
      //   
      LastExecuteMethod := cmFourier;
      LastExecuteSeries := cfFourierAB;
      // -----------------------
      //     
      CalculateAproximationStatistic(cmFourier, cfFourierAB);
      //     SG01AproxKoeff
      SetKoeffToSG01AproxKoeff(cmFourier);
      //     LViewBasis
      SetKoeffToLViewBasis (cmFourier);
      //    
      ShowDetalAproxFunc(cMaxDetalGraph, cmFourier, cfFourierAB);
      //      
      ShowSpectr(SpectrLineTab, AproximationColor);
      EndCodeReport('  ');
    end;
    // -----------------------
    //  
    Screen.Cursor := Save_Cursor;
  end;
end;  // of procedure

// ==========================================================
//      
// ==========================================================
// ----------------------------------------------------------
//
//      : An * Exp ( n * X )
function TestPolinomExpX( RqMaxInd : integer ) : boolean;
const MaxExp = 100;      //     n * X
var   MsgStr : string;
begin
 TestPolinomExpX := False;
 //    (TableFuncionArray - )
 if (RqMaxInd * TableFuncionArray[High(TableFuncionArray)].X) <= MaxExp
 then begin
    TestPolinomExpX := True;
 end
 else begin
    MsgStr := '       ( X = '
    + FloatToStr( TableFuncionArray[High(TableFuncionArray)].X ) + ' ) '
    + #13#10 + '      ( n = '
    + IntToStr(RqMaxInd) + ' )'
    + #13#10 + '      ( n * X < '
    + IntToStr(MaxExp) + ' )';
    MessageDlg( MsgStr, mtError, [mbOk], 0);
 end;
end; // of function
// ----------------------------------------------------------
//
//      : An * (( 1 / X ) ^ n )
function TestPolinom1DX ( RqMaxInd : integer ) : boolean;
var   Ind , IndAbsMinX     : word;
      MinX, AbsMinX, MaxX  : extended;
      MsgStr               : string;
begin
  TestPolinom1DX := False;
  //       
  IndAbsMinX :=  Low(TableFuncionArray);
  //  TableFuncionArray    
  MinX := TableFuncionArray[IndAbsMinX].X;
  MaxX := TableFuncionArray[High(TableFuncionArray)].X;
  if ( MinX <= 0 ) and ( MaxX >= 0)
  then begin
     MsgStr :=   '      '
      + #13#10 + '  = 0,       1 / '
      + #13#10 + '    .';
       MessageDlg( MsgStr, mtError, [mbOk], 0);
  end
  else begin
     //      
     AbsMinX := Abs(MinX);
     for Ind := Low(TableFuncionArray) to High(TableFuncionArray) do
     begin
        if Abs(TableFuncionArray[Ind].X) < AbsMinX
        then begin
          AbsMinX := Abs(TableFuncionArray[Ind].X);
          IndAbsMinX := Ind;  //   
        end;
     end;
     //       (   )
     if (RqMaxInd * Log10(AbsMinX)) <= (300 / 2)
     then begin
        // , : ((1 / 1.0E-15) ^ 20) = 1.0E+300
        //  150   (( 1 / X ) ^ RqMaxInd)
        //  150    .
        //    
        //  .
        TestPolinom1DX := True;
     end
     else begin
        MsgStr  := '  X   (  = '
        + IntToStr(IndAbsMinX) + ' )    '
        + #13#10 + '     '
        + #13#10 + '   ,    .';
        MessageDlg( MsgStr, mtError, [mbOk], 0);
     end;
  end;
end;  // of function
// ----------------------------------------------------------
//
//      : An * ( Ln ( X ) ^ n )
function TestPolinomLnX ( RqMaxInd : integer ) : boolean;
var   IndMinX      : word;
      MinX,  MaxX  : extended;
      MsgStr       : string;
begin
  TestPolinomLnX := False;
  //      ( )
  MinX := TableFuncionArray[Low(TableFuncionArray)].X;
  MaxX := TableFuncionArray[High(TableFuncionArray)].X;
  if ( MinX <= 0 ) and ( MaxX >= 0)
  then begin
     MsgStr :=   '      '
      + #13#10 + '  = 0,       Ln (  )'
      + #13#10 + '    .';
       MessageDlg( MsgStr, mtError, [mbOk], 0);
  end
  else begin
     IndMinX := Low(TableFuncionArray);
     if (MinX > 1.0E-300)  // (Ln(1.0E-300) ^ 20) = 6,12E+56
     then begin
        //   
        TestPolinomLnX := True;
     end
     else begin
        MsgStr  := '  X   (  = '
        + IntToStr(IndMinX) + ' )    '
        + #13#10 + '     '
        + #13#10 + '   ,    .';
        MessageDlg( MsgStr, mtError, [mbOk], 0);
     end;
  end;
end;  // of function
// ----------------------------------------------------------
//
//       
procedure VerifyAndRunLSquaresMethod(RqSeries : word; RqMaxInd : integer);
var WNumPoint, WInd : integer; FlagEnable : boolean;
begin
  //     
  WNumPoint := Length(TableFuncionArray);
  if (RqMaxInd >= 0) and (WNumPoint >= cTabFuncMinPCount)
  then begin
     WInd := RqMaxInd;
     //         Gauss01
     if WInd > cLSquaresMaxRqExp then WInd := cLSquaresMaxRqExp;
     //       
     if WInd > (WNumPoint - 1) then WInd := (WNumPoint - 1);
     //     ,  
     if (WInd = RqMaxInd)
     then begin
         case RqSeries of
           cfPolinomX    : begin //    X
               RunAproxLSquares(RqSeries, RqMaxInd)
           end;
           cfPolinom1DX   : begin //    1/X
               FlagEnable := TestPolinom1DX ( RqMaxInd );
               if FlagEnable then RunAproxLSquares(RqSeries, RqMaxInd);
           end;
           cfPolinomExpX : begin //    Exp(X)
               FlagEnable := TestPolinomExpX( RqMaxInd );
               if FlagEnable then RunAproxLSquares(RqSeries, RqMaxInd);
           end;
           cfPolinomLnX : begin //    Ln(X)
               FlagEnable := TestPolinomLnX( RqMaxInd );
               if FlagEnable then RunAproxLSquares(RqSeries, RqMaxInd);
           end;
         end; // of case RqSeries
     end
     else begin
         CtrlEdAproxMaxInd.Text := IntToStr(WInd);
         MessageDlg( '       '
          + #13#10 + '     '
          + #13#10 + '    .',
          mtWarning, [mbOk], 0);
     end;
  end;
end;  // of procedure

// -----------------------------------------------------
//
//      
procedure VerifyAndRunFourierMethod(RqSeries : word; RqMaxInd : integer);
var WNumPoint, WInd : integer;
begin
  //     
  WNumPoint := Length(TableFuncionArray);
  if (RqMaxInd >= 0) and (WNumPoint >= cTabFuncMinPCount)
  then begin
     WInd := RqMaxInd;
     //         
     WNumPoint := WNumPoint div 2;
     //       
     if WInd > WNumPoint then WInd := WNumPoint;
     //     ,  
     if (WInd = RqMaxInd)
     then begin
        case RqSeries of
            cfFourierAB : begin //     A,B
               RunAproxFourierAB(RqMaxInd);
            end;
        end; // of case
     end
     else begin
        CtrlEdAproxMaxInd.Text := IntToStr(WInd);
        MessageDlg( '      '
        + #13#10 + '  (.  ).'
        + #13#10 + '     '
        + #13#10 + '    .',
        mtWarning, [mbOk], 0);
      end;
  end;
end;  // of procedure

// ==========================================================
//      
// ==========================================================
// -----------------------------------------------------
//
//      CBoxAproxSelect
procedure RunSelectAprox();
var RqSeries, RqMethod  : word;
    SelectInd, RqMaxInd : integer;
begin
  if not FlagNeedXSortTabFunc
  then begin
     //      RqMaxInd
     if TextToInt(CtrlEdAproxMaxInd.Text, RqMaxInd)
     then begin
       if RqMaxInd > 0
       then begin
         //       
         SelectInd := CtrlCBoxAproxSelect.ItemIndex;
         if (SelectInd >= Low(ApproxSelectorList)) and
            (SelectInd <= High(ApproxSelectorList))
         then begin
            RqMethod := ApproxSelectorList[SelectInd].CodeM;
            RqSeries := ApproxSelectorList[SelectInd].CodeF;
            TermSeriesTxt := ApproxSelectorList[SelectInd].Func;
            case RqMethod of
             cmLSquares : VerifyAndRunLSquaresMethod(RqSeries, RqMaxInd);
             cmFourier  : VerifyAndRunFourierMethod(RqSeries, RqMaxInd);
            end;
         end;
       end;
     end;
  end
  else begin
     MessageDlg( '    '
      + #13#10 + '    ',
      mtWarning, [mbOk], 0);
  end;
end; // of procedure

// ==========================================================
// IMPLEMENTATION END
// ==========================================================
end.
